' ----------------------------------------------------------------------------
' Adds a sample to the Sample playing Queue
' ----------------------------------------------------------------------------
Function AddSample(id:Int)

	Local s:TSample = New TSample
	s.id = id

End Function



' ----------------------------------------------------------------------------
' Plays the Sample Queue
' ----------------------------------------------------------------------------
Function PlaySampleQueue()

	For Local s:TSample = EachIn samplelist
	
		If (Not ChannelPlaying(channel)) And s.active = False Then
		
			s.active = True
			PlaySample(s.id)
			
		Else If (Not ChannelPlaying(channel)) And s.active = True Then
		
			ListRemove(samplelist, s)
			s = Null

		EndIf
		
	Next

End Function



' ----------------------------------------------------------------------------
' plays a sample for a given ID
' ----------------------------------------------------------------------------
Function PlaySample(id:Int = 0)

	Local desc:String

	If channel Then StopChannel(channel)

	If id = 1 Then channel = CueSound(sounddrum) ; desc = "Sound: Drumroll"
	If id = 2 Then channel = CueSound(soundcash) ; desc = "Sound: Cash Register"
	If id = 3 Then channel = CueSound(soundhorn) ; desc = "Sound: Horn"
	If id = 4 Then channel = CueSound(soundwhoo) ; desc = "Sound: Whooooo"
	If id = 5 Then channel = CueSound(soundwater) ; desc = "Sound: Water"
	If id = 6 Then channel = CueSound(soundammonia) ; desc = "Sound: Laboratory"
	If id = 7 Then channel = CueSound(soundanvil) ; desc = "Sound: Anvil"
	If id = 8 Then channel = CueSound(soundblip1) ; desc = "Sound: Computer Blip 1"
	If id = 9 Then channel = CueSound(soundwork) ; desc = "Sound: Computer Blips Loop"
	If id = 10 Then channel = CueSound(soundfinish) ; desc = "Sound: Computer Finish Blip"
			
	If id = 11 Then channel = CueSound(voiceammonia) ; desc = "Voice: Ammonia World"
	If id = 12 Then channel = CueSound(voicebelt) ; desc = "Voice: Belt Cluster"
	If id = 13 Then channel = CueSound(voiceblackhole) ; desc = "Voice: Black Hole"
	If id = 14 Then channel = CueSound(voicecarbonstar) ; desc = "Voice: Carbon Star"
	If id = 15 Then channel = CueSound(voiceclass1) ; desc = "Voice: Class 1"
	If id = 16 Then channel = CueSound(voiceclass2) ; desc = "Voice: Class 2"
	If id = 17 Then channel = CueSound(voiceclass3) ; desc = "Voice: Class 3"
	If id = 18 Then channel = CueSound(voiceclass4) ; desc = "Voice: Class 4"
	If id = 19 Then channel = CueSound(voiceclass5) ; desc = "Voice: Class 5"
	
	'If id = 20 Then channel = CueSound(voicecongratulation) ; desc = "Voice: Congratulations"
	If id = 21 Then channel = CueSound(voiceearthlike) ; desc = "Voice: Earthlike"
	If id = 22 Then channel = CueSound(voiceexoticstar) ; desc = "Voice: Exotic Star"
	If id = 23 Then channel = CueSound(voicegiant) ; desc = "Voice: Giant"
	If id = 24 Then channel = CueSound(voiceheliumrich) ; desc = "Voice: Helium Rich"
	If id = 25 Then channel = CueSound(voicehighmetalcontent) ; desc = "Voice: High Metal Content"
	If id = 26 Then channel = CueSound(voiceicy) ; desc = "Voice: Icy"
	If id = 27 Then channel = CueSound(voicemetalrich) ; desc = "Voice: Metal Rich"
	If id = 28 Then channel = CueSound(voiceneutronstar) ; desc = "Voice: Neutron Star"
	If id = 29 Then channel = CueSound(voicerockyicy) ; desc = "Voice: Rocky Icy"
	If id = 30 Then channel = CueSound(voicerocky) ; desc = "Voice: Rocky"
	
	If id = 31 Then channel = CueSound(voicescancompleted) ; desc = "Voice: Scan completed"
	If id = 32 Then channel = CueSound(voicestara) ; desc = "Voice: Star Class A"
	If id = 33 Then channel = CueSound(voicestarb) ; desc = "Voice: Star Class B"
	If id = 34 Then channel = CueSound(voicestarf) ; desc = "Voice: Star Class F"
	If id = 35 Then channel = CueSound(voicestarg) ; desc = "Voice: Star Class G"
	If id = 36 Then channel = CueSound(voicestark) ; desc = "Voice: Star Class K"
	If id = 37 Then channel = CueSound(voicestarl) ; desc = "Voice: Star Class L"
	If id = 38 Then channel = CueSound(voicestarm) ; desc = "Voice: Star Class M"
	If id = 39 Then channel = CueSound(voicestaro) ; desc = "Voice: Star Class O"
	If id = 40 Then channel = CueSound(voicestart) ; desc = "Voice: Star Class T"
	
	If id = 41 Then channel = CueSound(voicestartts) ; desc = "Voice: Star Class T-Tauri"
	If id = 42 Then channel = CueSound(voicestary) ; desc = "Voice: Star Class Y"
	If id = 43 Then channel = CueSound(voicesudarski) ; desc = "Voice: Sudarsky Gas Giant"
	If id = 44 Then channel = CueSound(voicesupergiant) ; desc = "Voice: Super Giant"
	If id = 45 Then channel = CueSound(voiceterraformable) ; desc = "Voice: This Planet is - Terraformable"
	If id = 46 Then channel = CueSound(voicewatergiant) ; desc = "Voice: Water Giant"
	If id = 47 Then channel = CueSound(voicewaterworld) ; desc = "Voice: Water World"
	If id = 48 Then channel = CueSound(voicewelcome) ; desc = "Voice: Welcome Commander"
	If id = 49 Then channel = CueSound(voicewhitedwarf) ; desc = "Voice: White Dwarf"
	If id = 50 Then channel = CueSound(voicewithammonia) ; desc = "Voice: with Ammonia based Life"
	
	If id = 51 Then channel = CueSound(voicewithwater) ; desc = "Voice: with Water based Life"
	If id = 52 Then channel = CueSound(voicewolfrayetstar) ; desc = "Voice: Wolf-Rayet Star"
	If id = 53 Then channel = CueSound(voicepreciousplanet) ; desc = "Voice: Commander, this is a Precious Planet"
	If id = 54 Then channel = CueSound(voiceverypreciousplanet) ; desc = "Voice: Commander, this is a very Precious Planet"
	If id = 55 Then channel = CueSound(voicescoopable) ; desc = "Voice: This Star is Scoopable"
	If id = 56 Then channel = CueSound(voiceextremeradiation) ; desc = "Voice: Extreme Radiation detected"
	If id = 57 Then channel = CueSound(voiceextremegravity) ; desc = "Voice: Extreme Gravity detected"
	If id = 58 Then channel = CueSound(voiceextremeheat) ; desc = "Voice: Extreme Heat detected"
	If id = 59 Then channel = CueSound(voicedanger) ; desc = "Voice: Danger"
	If id = 60 Then channel = CueSound(voicebecareful) ; desc = "Voice: Be careful"
	
	If id = 61 Then channel = CueSound(voicerareobject) ; desc = "Voice: This is a very rare stellar object"
	If id = 62 Then channel = CueSound(soundblip2) ; desc = "Sound: Computer Blip 2"
	If id = 63 Then channel = CueSound(voicegasgiant) ; desc = "Voice: Gas Giant"
	If id = 64 Then channel = CueSound(voicemainsequence) ; desc = "Voice: Main Sequence"
	If id = 65 Then channel = CueSound(voicebrowndwarf) ; desc = "Voice: Brown Dwarf Star"

	If id = 67 Then channel = CueSound(voicenotscoopable) ; desc = "Voice: Not scoopable"
	If id = 68 Then channel = CueSound(voiceprotostar) ; desc = "Voice: Protostar"
	If id = 69 Then channel = CueSound(voicewarning) ; desc = "Voice: Warning"
	
	If id = 70 Then channel = CueSound(soundblip3) ; desc = "Sound: Computer Blip 3 (Ping)"
	
	'If id = 70 Then channel = CueSound(voicebye) ; desc = "Voice: Bye"
	
	LogUpdate("Playing " + desc)
		
	' set channelvolume
	SetChannelVolume(channel, channelvolume / 100.0)

	' play only if channel is free
	If Not ChannelPlaying(channel) Then

		ResumeChannel channel

	EndIf

End Function